#The Basic Bass Model   
# Parameter estimation by nonlinear least squares method 
# Script by S. Kido (June 14,2013)
#  m:  the market potential (market size)
#  p:  coefficient of innovation
#  q:  coefficient of imitation
# Input data
#  For your case ; replace the following values and title labels
subtitle  <- c(" Case Data : VCR 1980-1994(Lilien & Rangaswamy 1998, Exhibit 7.9 ,p.201)")
Tm <- 1:13                 # time (period) for computation
#Tmdlt <- (1:100) / 5       # use this script for smoothing the graph 
　Tmdlt <- 1:13             # use this script for comparison to input data 
Sales <- c(1.907
           ,2.981
           ,4.544
           ,6.657
           ,9.161
           ,11.464
           ,12.476
           ,11.217
           ,7.985
           ,4.472
           ,2.065
           ,0.846
           ,0.328
)
# followings are initial values for estimation
#p,q : average across studies(P=0.03, Q=0.38)
# m  : cum.value of input data (M=76)
IntM <-c(76)
IntP <-c(0.03)
IntQ <-c(0.38)
#
Cumsales <- cumsum(Sales)
# compute coefficient m,p,q
B_Bass.nls <- nls(Sales ~ M * ( ((P+Q)^2 / P) * exp(-(P+Q) * Tm) ) /(1+(Q/P)*exp(-(P+Q)*Tm))^2, 
     start = list(M=IntM, P=IntP, Q=IntQ) )
summary(B_Bass.nls)
BBcoef <- coef(B_Bass.nls)
m <- BBcoef[1]
p <- BBcoef[2]
q <- BBcoef[3]
# setting the starting value for M to the recorded total sales.
nmkt<- exp(-(p+q) * Tmdlt)
#
par(cex=0.9, pch=1,mfrow=c(2,1),col=1,lty=1,lwd=1)
# plot sales per period 
BBprd <- m * ( (p+q)^2 / p ) * nmkt / (1 + (q/p) * nmkt)^2
BBprd
plot(Tmdlt, BBprd ,
main="Sales per period ",
 ,xlab = "Year ",ylab = "Sales", 
 type='l',col="red")
points(Tm, Sales)
# plot cum. sales per period
BBcumd <- m * (1 - nmkt)/(1 + (q/p)*nmkt)
BBcumd
plot(Tmdlt, BBcumd , 
main="Cumulative Sales per period ",
sub=subtitle 
,xlab = "Year",ylab = "Cumulative sales", 
type='l',col="red")
points(Tm, Cumsales)
lines(Tmdlt,BBcumd ,col="green")
